/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.rsf;

import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.util.Collection;
import java.util.Iterator;

public class FixpackDownloadRequestBody
extends XFrameRsfRequestBody {
    private static final String TRACE_MASKT = "XRSFIP T";
    private static final String TRACE_MASKF = "XRSFIP F";
    private static final String TRACE_MASKD = "XRSFIP D";
    public static final String STAGING_DIRECTORY = "Staging Directory";
    Collection fixpackList = null;
    private static final int fileNameLength = 19;
    private static final int firstUnderscoreIndex = 7;
    private static final int secondUnderscoreIndex = 11;

    public FixpackDownloadRequestBody() {
        this.functionUserid = (char)68;
        this.functionId = (char)49;
    }

    public FixpackDownloadRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
        this.fixpackList = ((Persistent)data).fixpackList;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.fixpackList = this.fixpackList;
        return result;
    }

    public void setFixpackList(Collection fixpacks) throws IllegalArgumentException {
        if (fixpacks == null || fixpacks.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.fixpackList = fixpacks;
    }

    public Collection getFixpackList() {
        return this.fixpackList;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.getAttribute(STAGING_DIRECTORY) == null) {
            this.invalidMessage = "No staging directory specified.";
        } else if (this.fixpackList == null || this.fixpackList.isEmpty()) {
            this.invalidMessage = "No fixpack list specified.";
        } else {
            return true;
        }
        Trace.trace(TRACE_MASKF, "FixpackDownloadRequestBody.isValid: " + this.invalidMessage);
        return false;
    }

    protected String buildFixpackFileListXmlFormat(Collection fixpackList, boolean toString) throws ClassCastException {
        StringBuffer buffer;
        block7: {
            if (fixpackList == null || fixpackList.isEmpty()) {
                return "";
            }
            buffer = new StringBuffer("<FIXPACKS>");
            if (toString) {
                buffer.append('\n');
            }
            try {
                Iterator files = fixpackList.iterator();
                while (files.hasNext()) {
                    String currentFile = this.convertFileName((String)files.next());
                    if (toString) {
                        buffer.append("  ");
                    }
                    buffer.append("<FP>" + currentFile + "</FP>");
                    if (!toString) continue;
                    buffer.append('\n');
                }
            }
            catch (ClassCastException e) {
                Trace.trace(TRACE_MASKF, "List of fixpacks contains a non-String object");
                if (!toString) break block7;
                throw e;
            }
        }
        buffer.append("</FIXPACKS>");
        if (toString) {
            buffer.append('\n');
        }
        return buffer.toString();
    }

    String convertFileName(String input) throws IllegalArgumentException {
        if (input.length() != 19) {
            throw new IllegalArgumentException("Error in fixpack file name '" + input + "': invalid filename length=" + input.length());
        }
        if (input.charAt(7) != '_' || input.charAt(11) != '_') {
            throw new IllegalArgumentException("Error in fixpack file name'" + input + "': invalid format not PPNNSS_FFF_DDD.xxx");
        }
        if (input.substring(15, 19).equalsIgnoreCase(".rpm")) {
            return "I" + input.substring(0, 7) + input.substring(8, 11) + " " + input.substring(12, 15);
        }
        if (input.substring(15, 19).equalsIgnoreCase(".xml")) {
            return "C" + input.substring(0, 7) + input.substring(8, 11) + " " + input.substring(12, 15);
        }
        throw new IllegalArgumentException("Error converting fixpack name '" + input + "': invalid suffix:" + input.substring(15));
    }

    public String toXmlTransferFormat() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toXmlTransferFormat());
        buffer.append(this.buildFixpackFileListXmlFormat(this.fixpackList, false));
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toString());
        buffer.append(this.buildFixpackFileListXmlFormat(this.fixpackList, true));
        return buffer.toString();
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        Collection fixpackList;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

